-- Microsoft SQL Server DDL
-- create constraints and indices script

-- start
use pcweek
go
select "starting full indexing run", getdate()
go

-- uniques (3 indices, 1 of which is clustered)
select "creating uniques indices", getdate()
go

alter table uniques add constraint uniques_key_PK_IDX primary key clustered (u_key) with fillfactor=90
go
alter table uniques add constraint uniques_signed_CK_IDX unique nonclustered (u_signed) with fillfactor=90
go
alter table uniques add constraint uniques_code_CK_IDX unique nonclustered (u_code) with fillfactor=90
go

select "finished creating uniques indices", getdate()
go

-- hundred (6 indices, 1 of which is clustered)
select "creating hundred indices", getdate()
go

alter table hundred add constraint hundred_key_PK_IDX primary key clustered (h_key) with fillfactor=90
go
create nonclustered index hundred_int_IDX on hundred (h_int) with fillfactor=90
go
create nonclustered index hundred_signed_IDX on hundred (h_signed) with fillfactor=90
go
create nonclustered index hundred_date_IDX on hundred (h_date) with fillfactor=90
go
alter table hundred add constraint hundred_code_CK_IDX unique nonclustered (h_code) with fillfactor=90
go
create nonclustered index hundred_name_IDX on hundred (h_name) with fillfactor=90
go

select "finished creating hundred indices", getdate()
go

-- tenpct (9 indices, 1 of which is clustered)
select "creating tenpct indices", getdate()
go

alter table tenpct add constraint tenpct_key_code_PK_IDX primary key clustered (t_key, t_code) with fillfactor=90
go
create nonclustered index tenpct_int_IDX on tenpct (t_int) with fillfactor=90
go
create nonclustered index tenpct_signed_IDX on tenpct (t_signed) with fillfactor=90
go
create nonclustered index tenpct_float_IDX on tenpct (t_float) with fillfactor=90
go
create nonclustered index tenpct_double_IDX on tenpct (t_double) with fillfactor=90
go
create nonclustered index tenpct_decim_IDX on tenpct (t_decim) with fillfactor=90
go
create nonclustered index tenpct_date_IDX on tenpct (t_date) with fillfactor=90
go
alter table tenpct add constraint tenpct_code_CK_IDX unique nonclustered (t_code) with fillfactor=90
go
create nonclustered index tenpct_name_IDX on tenpct (t_name) with fillfactor=90
go

select "finished creating tenpct indices", getdate()
go

-- updates (6 indices, 1 of which is clustered, 1 foreign key)
select "creating updates indices", getdate()
go

alter table updates add constraint updates_key_PK_IDX primary key clustered (p_key) with fillfactor=90
go
create nonclustered index updates_int_IDX on updates (p_int) with fillfactor=90
go
alter table updates add constraint updates_int_FK foreign key (p_int) references hundred (h_key)
go
create nonclustered index updates_signed_IDX on updates (p_signed) with fillfactor=90
go
create nonclustered index updates_decim_IDX on updates (p_decim) with fillfactor=90
go
create nonclustered index updates_date_IDX on updates (p_date) with fillfactor=90
go
create nonclustered index updates_code_IDX on updates (p_code) with fillfactor=90
go

select "finished creating updates indices", getdate()
go

-------------------------

-- tenthou (5 indices, 1 of which is clustered)
select "creating tenthou indices", getdate()
go

alter table tenthou add constraint tenthou_key_code_PK_IDX primary key clustered (t_key, t_code) with fillfactor=90
go
create nonclustered index tenthou_signed_IDX on tenthou (t_signed) with fillfactor=90
go
create nonclustered index tenthou_decim_IDX on tenthou (t_decim) with fillfactor=90
go
alter table tenthou add constraint tenthou_code_CK_IDX unique nonclustered (t_code) with fillfactor=90
go
create nonclustered index tenthou_name_IDX on tenthou (t_name) with fillfactor=90
go

select "finished creating tenthou indices", getdate()
go

-- hunthou (1 index)
select "creating hunthou indices", getdate()
go

create nonclustered index hunthou_signed_IDX on hunthou (h_signed) with fillfactor=90
go

select "finished creating hunthou indices", getdate()
go

-- twomill (3 indices)
select "creating twomill indices", getdate()
go

alter table twomill add constraint twomill_code_PK_IDX unique nonclustered (p_key) with fillfactor=90
go
create nonclustered index twomill_date_IDX on twomill (p_date) with fillfactor=90
go
alter table twomill add constraint twomill_code_CK_IDX unique nonclustered (p_code) with fillfactor=90
go

select "creating twomill indices", getdate()
go

-- threemill (1 index)
select "creating threemill indices", getdate()
go

create nonclustered index threemill_signed_IDX on threemill (t_signed) with fillfactor=90
go

select "finished creating threemill indices", getdate()
go

-- fourmill (0 indices)
select "creating fourmill indices", getdate()
go

select "finished creating fourmill indices", getdate()
go

-- fivemill (2 indices)
select "creating fivemill indices", getdate()
go

alter table fivemill add constraint fivemill_key_PK_IDX unique nonclustered (h_key) with fillfactor=90
go
alter table fivemill add constraint fivemill_code_CK_IDX unique nonclustered (h_code) with fillfactor=90
go

select "finished creating fivemill indices", getdate()
go

-- sevmill (1 index)
select "creating sevmill indices", getdate()
go

alter table sevmill add constraint sevmill_key_PK_IDX unique nonclustered (u_key) with fillfactor=90
go

select "finished creating sevmill indices", getdate()
go

-- fourtymill (0 indices)
select "creating fourtymill indices", getdate()
go

select "finished creating fourtymill indices", getdate()
go

-- upd_history (1 index, 1 of which is clustered)
select "creating upd_history indices", getdate()
go

alter table upd_history add constraint upd_history_key_PK_IDX primary key clustered (x_key) with fillfactor=90
go

select "finished creating upd_history indices", getdate()
go

-- end
select "finished full indexing run", getdate()
go
checkpoint
go
